<?php

use Elementor\Icons_Manager;

// Icon
$icon_html = $icon_array = '';
$custom_icon_enabled = get_post_meta( get_the_ID(), 'cspt-custom-icon-enabled', true );
if( $custom_icon_enabled=='1' ){
	$img_src = '';
	$custom_icon_url = get_post_meta( get_the_ID(), 'cspt-custom-icon', true );
	if( !empty($custom_icon_url) ){
		$img_src = wp_get_attachment_image_src($custom_icon_url, 'full');
		if( !empty($img_src[0]) ){ $custom_icon_url = $img_src[0]; }
	}
	$icon_html = '<img src="'.$custom_icon_url.'"/>';
}else{
	$icon_lib = get_post_meta( get_the_ID(), 'cspt-service-icon-library', true );
	wp_enqueue_style($icon_lib);
	$icon_class = get_post_meta( get_the_ID(), 'cspt-service-icon-'.$icon_lib, true );

	// icon library name for the function
	$icon_lib2 = $icon_lib;
	if( $icon_lib == 'elementor-icons-fa-regular' ){
		$icon_lib2 = 'fa-regular';
	} else if( $icon_lib == 'elementor-icons-fa-solid' ){
		$icon_lib2 = 'fa-solid';
	} else if( $icon_lib == 'elementor-icons-fa-brands' ){
		$icon_lib2 = 'fa-brands';
	}
	$icon_array = array(
		'value' => $icon_class,
		'library' => $icon_lib2,
	);
}
// Read More text
if( !isset($more_text) ){
	$more_text = esc_attr__('Read More','leblix');
}
?>
<div class="creativesplanet-post-item">
	<?php cspt_get_featured_data( array( 'featured_img_only' => true, 'size' => 'cspt-img-720x540' ) ); ?>
	<div class="creativesplanet-box-content">
		<div class="creativesplanet-box-content-inner">
			<div class="cspt-title-inner d-flex justify-content-between">
				<h3 class="cspt-service-title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
				<div class="cspt-service-icon-wrapper">
					<?php if( !empty($icon_html)){
						echo cspt_esc_kses ( $icon_html );
					} else {
						Icons_Manager::render_icon( $icon_array, [ 'aria-hidden' => 'true' ] );
					} ?>
				</div>
			</div>
		<div class="creativesplanet-box-des">
			<?php if( has_excerpt() ) : ?>
				<div class="cspt-service-content"><?php the_excerpt(); ?></div>
			<?php endif; ?>
		</div>
		</div>
	</div>
</div>